﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using CashierCrisis.UserInterface;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Managers
{
    public class UIManager : DrawableGameComponent
    {
        private Stack<UI> _uiStack = new Stack<UI>();
        private Dictionary<string, UI> _uiDictionary = new Dictionary<string, UI>();
        private SpriteBatch spriteBatch;

        public UIManager(Game game)
            :base(game)
        {
            spriteBatch = game.Services.GetService(typeof(SpriteBatch)) as SpriteBatch;
            DrawOrder = 100;
        }

        public override void Update(GameTime gameTime)
        {
            if (!(_uiStack.Count == 0))
            {
                UI ui = _uiStack.Peek();
                ui.Update(gameTime);
            }

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            spriteBatch.Begin();

            if (!(_uiStack.Count == 0))
            {
                List<UI> uiList = new List<UI>(_uiStack.AsEnumerable<UI>());
                int count = uiList.Count;

                for (int i = 0; i < count; i++)
                {
                    UI ui = uiList[i];

                    if (ui.Visible)
                    {
                        ui.Draw(spriteBatch);
                    }
                }

            }
            spriteBatch.End();
            base.Draw(gameTime);
        }

        public void SwapUserInterface(UI ui)
        {
            PopUserInterface();
            PushUserInterface(ui);
        }

        public void SwapUserInterface(string uiName)
        {
            SwapUserInterface(_uiDictionary[uiName]);
        }

        public void PushUserInterface(UI ui)
        {
            _uiStack.Push(ui);
        }

        public void PushUserInterface(string uiName)
        {
            PushUserInterface(_uiDictionary[uiName]);
        }

       
        public void PopUserInterface()
        {
            if (_uiStack.Count > 0)
            {
                _uiStack.Pop();
            }
        }

        public void AddUserInterface(string uiName, UI ui)
        {
            _uiDictionary.Add(uiName, ui);
        }

        public UI GetUserInterface(string uiName)
        {
            return _uiDictionary[uiName];
        }

        public bool IsShowing(string uiName)
        {
            if (!_uiStack.Contains(_uiDictionary[uiName]))
            {
                return false;
            }
            return (_uiDictionary[uiName] == _uiStack.Peek());
        }
    
    }
}
